﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class CompressOldFiles : UserControl, ICorrespondenceOS, IControl
    {
        private CompressOldFilesController compressOldFilesController;

        public CompressOldFiles()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
            
        }

        public void SetCompressOldFilesState(bool b)
        {
            checkBox1.Checked = b;
        }

        public bool GetCompressOldFilesState()
        {
            return checkBox1.Checked;
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:compress_old_files"));
                userHelp.Show();
            }
        }

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IControl メンバ

        public void Apply()
        {
            compressOldFilesController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return compressOldFilesController.BackUp();
        }

        #endregion

        private void CompressOldFiles_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            compressOldFilesController = new CompressOldFilesController(this,
                                                                                    (ICompressOldFilesStrategy)
                                                                                    wfUtillity.GetCorrespondenceInstance
                                                                                        (new List<ICorrespondenceOS>
                                                                                             {
                                                                                                 new CompressOldFilesDefaultStrategy()
                                                                                             }));
            compressOldFilesController.Read();
        }
    }
}
